<?php

declare(strict_types=1);

namespace Square\Models;

use stdClass;

class DestinationDetailsCardRefundDetails implements \JsonSerializable
{
    /**
     * @var Card|null
     */
    private $card;

    /**
     * @var array
     */
    private $entryMethod = [];

    /**
     * Returns Card.
     * Represents the payment details of a card to be used for payments. These
     * details are determined by the payment token generated by Web Payments SDK.
     */
    public function getCard(): ?Card
    {
        return $this->card;
    }

    /**
     * Sets Card.
     * Represents the payment details of a card to be used for payments. These
     * details are determined by the payment token generated by Web Payments SDK.
     *
     * @maps card
     */
    public function setCard(?Card $card): void
    {
        $this->card = $card;
    }

    /**
     * Returns Entry Method.
     * The method used to enter the card's details for the refund. The method can be
     * `KEYED`, `SWIPED`, `EMV`, `ON_FILE`, or `CONTACTLESS`.
     */
    public function getEntryMethod(): ?string
    {
        if (count($this->entryMethod) == 0) {
            return null;
        }
        return $this->entryMethod['value'];
    }

    /**
     * Sets Entry Method.
     * The method used to enter the card's details for the refund. The method can be
     * `KEYED`, `SWIPED`, `EMV`, `ON_FILE`, or `CONTACTLESS`.
     *
     * @maps entry_method
     */
    public function setEntryMethod(?string $entryMethod): void
    {
        $this->entryMethod['value'] = $entryMethod;
    }

    /**
     * Unsets Entry Method.
     * The method used to enter the card's details for the refund. The method can be
     * `KEYED`, `SWIPED`, `EMV`, `ON_FILE`, or `CONTACTLESS`.
     */
    public function unsetEntryMethod(): void
    {
        $this->entryMethod = [];
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->card)) {
            $json['card']         = $this->card;
        }
        if (!empty($this->entryMethod)) {
            $json['entry_method'] = $this->entryMethod['value'];
        }
        $json = array_filter($json, function ($val) {
            return $val !== null;
        });

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
